/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jfx.incubator.scene.control.richtext.util;

import com.sun.javafx.scene.text.TextFlowHelper;
import com.sun.javafx.scene.text.TextLayout;
import com.sun.javafx.scene.text.TextLine;
import com.sun.jfx.incubator.scene.control.richtext.util.ImgUtil;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Locale;
import javafx.application.ConditionalFeature;
import javafx.application.Platform;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Point2D;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.image.Image;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.PathElement;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.scene.text.TextFlow;
import javax.imageio.ImageIO;
import jfx.incubator.scene.control.richtext.model.StyleAttributeMap;

public final class RichUtils {
    private static final DecimalFormat format = new DecimalFormat("#0.##");

    private RichUtils() {
    }

    public static String substring(String string, int n, int n2) {
        if (string == null) {
            return "";
        }
        int n3 = string.length();
        if (n2 < 0 || n2 > n3) {
            n2 = n3;
        }
        if (n == 0 && n2 == n3) {
            return string;
        }
        return string.substring(n, n2);
    }

    public static String toCssColor(Color color) {
        if (color.getOpacity() == 1.0) {
            return String.format("#%02x%02x%02x", RichUtils.eightBit(color.getRed()), RichUtils.eightBit(color.getGreen()), RichUtils.eightBit(color.getBlue()));
        }
        return String.format("rgba(%d,%d,%d,%f)", RichUtils.eightBit(color.getRed()), RichUtils.eightBit(color.getGreen()), RichUtils.eightBit(color.getBlue()), color.getOpacity());
    }

    public static String toWebColor(Color color) {
        return String.format("#%02x%02x%02x", RichUtils.eightBit(color.getRed()), RichUtils.eightBit(color.getGreen()), RichUtils.eightBit(color.getBlue()));
    }

    private static int eightBit(double d) {
        int n = (int)Math.round(d * 255.0);
        if (n < 0) {
            return 0;
        }
        if (n > 255) {
            return 255;
        }
        return n;
    }

    public static boolean notEquals(Object object, Object object2) {
        return !RichUtils.equals(object, object2);
    }

    public static boolean equals(Object object, Object object2) {
        if (object == object2) {
            return true;
        }
        if (object == null) {
            return object2 == null;
        }
        if (object2 == null) {
            return false;
        }
        return object.equals(object2);
    }

    public static boolean isTouchSupported() {
        return Platform.isSupported(ConditionalFeature.INPUT_TOUCH);
    }

    public static int getTextLength(TextFlow textFlow) {
        int n = 0;
        for (Node node : textFlow.getChildrenUnmodifiable()) {
            if (node instanceof Text) {
                Text text = (Text)node;
                n += text.getText().length();
                continue;
            }
            ++n;
        }
        return n;
    }

    public static PathElement[] translatePath(Region region, Region region2, PathElement[] pathElementArray, double d, double d2) {
        Point2D point2D = region2.localToScreen(0.0, 0.0);
        if (point2D == null) {
            return null;
        }
        Point2D point2D2 = region.localToScreen(region.snappedLeftInset(), region.snappedTopInset());
        double d3 = point2D.getX() - point2D2.getX() + d;
        double d4 = point2D.getY() - point2D2.getY() + d2;
        for (int i = 0; i < pathElementArray.length; ++i) {
            PathElement pathElement = pathElementArray[i];
            if (pathElement instanceof LineTo) {
                LineTo lineTo = (LineTo)pathElement;
                pathElement = new LineTo(lineTo.getX() + d3, lineTo.getY() + d4);
            } else if (pathElement instanceof MoveTo) {
                MoveTo moveTo = (MoveTo)pathElement;
                pathElement = new MoveTo(moveTo.getX() + d3, moveTo.getY() + d4);
            } else {
                throw new RuntimeException("unexpected path element " + String.valueOf(pathElement));
            }
            pathElementArray[i] = pathElement;
        }
        return pathElementArray;
    }

    public static boolean isLogicalFont(String string) {
        switch (string) {
            case "System": 
            case "Serif": 
            case "SansSerif": 
            case "Monospaced": {
                return true;
            }
        }
        return false;
    }

    public static String guessFontStyle(String string) {
        if (string.contains("italic")) {
            return "italic";
        }
        if (string.contains("oblique")) {
            return "oblique";
        }
        return "normal";
    }

    public static String guessFontWeight(String string) {
        if (string.contains("thin")) {
            return "100";
        }
        if (string.contains("extralight")) {
            return "200";
        }
        if (string.contains("light")) {
            return "300";
        }
        if (string.contains("medium")) {
            return "500";
        }
        if (string.contains("semibold")) {
            return "600";
        }
        if (string.contains("demibold")) {
            return "600";
        }
        if (string.contains("bold")) {
            return "700";
        }
        if (string.contains("extrabold")) {
            return "800";
        }
        if (string.contains("heavy")) {
            return "900";
        }
        return "normal";
    }

    public static boolean isBold(String string) {
        return string.contains("bold") || string.contains("extrabold") || string.contains("heavy");
    }

    public static boolean isItalic(String string) {
        return string.contains("italic") || string.contains("oblique");
    }

    public static String dump(PathElement[] pathElementArray) {
        StringBuilder stringBuilder = new StringBuilder();
        if (pathElementArray == null) {
            stringBuilder.append("null");
        } else {
            for (PathElement pathElement : pathElementArray) {
                if (pathElement instanceof MoveTo) {
                    MoveTo moveTo = (MoveTo)pathElement;
                    stringBuilder.append('M');
                    stringBuilder.append(RichUtils.r(moveTo.getX()));
                    stringBuilder.append(',');
                    stringBuilder.append(RichUtils.r(moveTo.getY()));
                    stringBuilder.append(' ');
                    continue;
                }
                if (pathElement instanceof LineTo) {
                    LineTo lineTo = (LineTo)pathElement;
                    stringBuilder.append('L');
                    stringBuilder.append(RichUtils.r(lineTo.getX()));
                    stringBuilder.append(',');
                    stringBuilder.append(RichUtils.r(lineTo.getY()));
                    stringBuilder.append(' ');
                    continue;
                }
                stringBuilder.append(pathElement);
                stringBuilder.append(' ');
            }
        }
        return stringBuilder.toString();
    }

    private static int r(double d) {
        return (int)Math.round(d);
    }

    public static String toCss(TextAlignment textAlignment) {
        switch (textAlignment) {
            case CENTER: {
                return "center";
            }
            case JUSTIFY: {
                return "justify";
            }
            case RIGHT: {
                return "right";
            }
        }
        return "left";
    }

    public static String formatDouble(Double d) {
        return format.format(d);
    }

    @Deprecated
    public static char encodeAlignment(TextAlignment textAlignment) {
        switch (textAlignment) {
            case CENTER: {
                return 'C';
            }
            case JUSTIFY: {
                return 'J';
            }
            case RIGHT: {
                return 'R';
            }
        }
        return 'L';
    }

    @Deprecated
    public static TextAlignment decodeAlignment(int n) throws IOException {
        switch (n) {
            case 67: {
                return TextAlignment.CENTER;
            }
            case 74: {
                return TextAlignment.JUSTIFY;
            }
            case 76: {
                return TextAlignment.LEFT;
            }
            case 82: {
                return TextAlignment.RIGHT;
            }
        }
        throw new IOException("failed parsing alignment (" + (char)n + ")");
    }

    public static StyleAttributeMap combine(StyleAttributeMap styleAttributeMap, StyleAttributeMap styleAttributeMap2) {
        if (styleAttributeMap != null && !styleAttributeMap.isEmpty()) {
            if (styleAttributeMap2 == null) {
                return styleAttributeMap;
            }
            return StyleAttributeMap.builder().merge(styleAttributeMap).merge(styleAttributeMap2).build();
        }
        return styleAttributeMap2;
    }

    public static List<CssMetaData<? extends Styleable, ?>> combine(List<CssMetaData<? extends Styleable, ?>> list, CssMetaData<? extends Styleable, ?> ... cssMetaDataArray) {
        CssMetaData[] cssMetaDataArray2 = new CssMetaData[list.size() + cssMetaDataArray.length];
        list.toArray(cssMetaDataArray2);
        System.arraycopy(cssMetaDataArray, 0, cssMetaDataArray2, list.size(), cssMetaDataArray.length);
        return List.of(cssMetaDataArray2);
    }

    public static String readString(InputStream inputStream) throws IOException {
        int n;
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
        StringBuilder stringBuilder = new StringBuilder(65536);
        while ((n = inputStreamReader.read()) >= 0) {
            stringBuilder.append((char)n);
        }
        return stringBuilder.toString();
    }

    public static byte[] writePNG(Image image) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(65536);
        ImageIO.setUseCache(false);
        ImageIO.write((RenderedImage)ImgUtil.fromFXImage(image, null), "PNG", byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static boolean isLetterOrDigit(String string, int n) {
        if (n < 0) {
            return false;
        }
        if (n >= string.length()) {
            return false;
        }
        int n2 = Character.codePointAt(string, n);
        return Character.isLetterOrDigit(n2);
    }

    public static int nextCodePoint(String string, int n) {
        int n2 = string.length();
        if (n < n2) {
            char c;
            char c2;
            if (Character.isHighSurrogate(c2 = string.charAt(n++)) && n < n2 && Character.isLowSurrogate(c = string.charAt(n))) {
                ++n;
            }
            return n;
        }
        return n2;
    }

    public static Bounds[] pathToBoundsArray(Node node, PathElement[] pathElementArray) {
        Bounds[] boundsArray = new Bounds[pathElementArray.length / 5];
        int n = 0;
        for (int i = 0; i < boundsArray.length; ++i) {
            MoveTo moveTo = (MoveTo)pathElementArray[n];
            LineTo lineTo = (LineTo)pathElementArray[n + 1];
            LineTo lineTo2 = (LineTo)pathElementArray[n + 2];
            BoundingBox boundingBox = new BoundingBox(moveTo.getX(), moveTo.getY(), lineTo.getX() - moveTo.getX(), lineTo2.getY() - lineTo.getY());
            boundsArray[i] = node.localToScreen(boundingBox);
            n += 5;
        }
        return boundsArray;
    }

    private static int parseInt(Object object) {
        if (object instanceof Integer) {
            Integer n = (Integer)object;
            return n;
        }
        return 0;
    }

    public static int lineForOffset(TextFlow textFlow, int n) {
        TextLayout textLayout = TextFlowHelper.getTextLayout(textFlow);
        TextLine[] textLineArray = textLayout.getLines();
        int n2 = 0;
        for (int i = 1; i < textLineArray.length; ++i) {
            TextLine textLine = textLineArray[i];
            if (textLine.getStart() > n) {
                return n2;
            }
            ++n2;
        }
        return n2;
    }

    public static Integer lineStart(TextFlow textFlow, int n) {
        TextLayout textLayout = TextFlowHelper.getTextLayout(textFlow);
        TextLine[] textLineArray = textLayout.getLines();
        if (0 <= n && n < textLineArray.length) {
            TextLine textLine = textLineArray[n];
            return textLine.getStart();
        }
        return null;
    }

    public static Integer lineEnd(TextFlow textFlow, int n) {
        TextLayout textLayout = TextFlowHelper.getTextLayout(textFlow);
        TextLine[] textLineArray = textLayout.getLines();
        if (0 <= n && n < textLineArray.length) {
            TextLine textLine = textLineArray[n];
            return textLine.getStart() + textLine.getLength();
        }
        return null;
    }

    public static void layoutInArea(Node node, double d, double d2, double d3, double d4) {
        boolean bl;
        Parent parent = node.getParent();
        if (parent instanceof Region) {
            Region region = (Region)parent;
            bl = region.isSnapToPixel();
        } else {
            bl = false;
        }
        boolean bl2 = bl;
        Region.layoutInArea(node, d, d2, d3, d4, 0.0, Insets.EMPTY, true, true, HPos.CENTER, VPos.CENTER, bl2);
    }

    public static double computeMidPointY(PathElement[] pathElementArray) {
        double d = Double.POSITIVE_INFINITY;
        double d2 = Double.NEGATIVE_INFINITY;
        for (PathElement pathElement : pathElementArray) {
            double d3;
            if (pathElement instanceof LineTo) {
                LineTo lineTo = (LineTo)pathElement;
                d3 = lineTo.getY();
                if (d > d3) {
                    d = d3;
                }
                if (!(d2 < d3)) continue;
                d2 = d3;
                continue;
            }
            if (!(pathElement instanceof MoveTo)) continue;
            MoveTo moveTo = (MoveTo)pathElement;
            d3 = moveTo.getY();
            if (d > d3) {
                d = d3;
            }
            if (!(d2 < d3)) continue;
            d2 = d3;
        }
        return d == Double.POSITIVE_INFINITY ? 0.0 : (d2 + d) / 2.0;
    }

    public static StyleAttributeMap fromTextNode(Text text) {
        Paint paint;
        StyleAttributeMap.Builder builder = StyleAttributeMap.builder();
        Font font = text.getFont();
        String string = font.getStyle().toLowerCase(Locale.US);
        boolean bl = RichUtils.isBold(string);
        boolean bl2 = RichUtils.isItalic(string);
        if (bl) {
            builder.setBold(true);
        }
        if (bl2) {
            builder.setItalic(true);
        }
        if (text.isStrikethrough()) {
            builder.setStrikeThrough(true);
        }
        if (text.isUnderline()) {
            builder.setUnderline(true);
        }
        String string2 = font.getFamily();
        builder.setFontFamily(string2);
        double d = font.getSize();
        if (d != 12.0) {
            builder.setFontSize(d);
        }
        if ((paint = text.getFill()) instanceof Color) {
            Color color = (Color)paint;
            builder.setTextColor(color);
        }
        return builder.build();
    }
}

